/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.security;

import de.willuhn.jameica.security.SSLFactory;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Arrays;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class JameicaTrustManager
implements X509TrustManager {
    private X509TrustManager systemTrustManager = null;
    private X509TrustManager parentTrustManager = null;
    private CertPathValidator validator = CertPathValidator.getInstance("PKIX", "BC");

    public JameicaTrustManager() throws KeyStoreException, Exception {
        if (Application.getConfig().getTrustJavaCerts()) {
            Logger.info((String)"trusting java trustmanager");
            this.parentTrustManager = this.getSystemTrustManager();
        } else {
            Logger.info((String)"system trustmanager disabled, will use only jameicas trustmanager");
        }
    }

    public synchronized X509TrustManager getSystemTrustManager() throws Exception {
        if (this.systemTrustManager != null) {
            return this.systemTrustManager;
        }
        TrustManagerFactory factory = null;
        try {
            Logger.info((String)"loading trustmanager SunX509");
            factory = TrustManagerFactory.getInstance("SunX509");
        }
        catch (NoSuchAlgorithmException e) {
            Logger.info((String)"failed. fallback to IbmX509");
            factory = TrustManagerFactory.getInstance("IbmX509");
        }
        factory.init((KeyStore)null);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers == null || trustmanagers.length == 0) {
            Logger.warn((String)"NO system trustmanager found");
            return null;
        }
        this.systemTrustManager = (X509TrustManager)trustmanagers[0];
        return this.systemTrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.parentTrustManager != null) {
            try {
                Logger.debug((String)"checking client certificate via system trustmanager");
                this.parentTrustManager.checkClientTrusted(chain, authType);
                Logger.info((String)("client certificate trusted via system trustmanager [vendor: " + System.getProperty("java.vendor") + "]"));
            }
            catch (CertificateException c) {
                Logger.debug((String)"client certificate not found in system trustmanager, trying jameica trustmanager");
                Logger.write((Level)Level.DEBUG, (String)"CertificateException for debugging", (Throwable)c);
                this.checkTrusted(chain, authType);
            }
        } else {
            Logger.info((String)"no system trustmanager found, checking client certificate via jameica trustmanager");
            this.checkTrusted(chain, authType);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (this.parentTrustManager != null) {
            try {
                Logger.debug((String)"checking server certificate via system trustmanager");
                this.parentTrustManager.checkServerTrusted(certificates, authType);
                Logger.debug((String)("server certificate trusted via system trustmanager [vendor: " + System.getProperty("java.vendor") + "]"));
            }
            catch (CertificateException c) {
                Logger.debug((String)"server certificate not found in system trustmanager, trying jameica trustmanager");
                if (Logger.isLogging((Level)Level.DEBUG)) {
                    Logger.write((Level)Level.DEBUG, (String)"CertificateException for debugging", (Throwable)c);
                    X509Certificate[] trusted = this.getAcceptedIssuers();
                    if (trusted != null && trusted.length > 0) {
                        Logger.debug((String)"jameica keystore contains the following certificates:");
                        for (int i = 0; i < trusted.length; ++i) {
                            Logger.debug((String)("  " + this.toString(trusted[i])));
                        }
                    } else {
                        Logger.debug((String)"jameica keystore contains no certificates");
                    }
                }
                this.checkTrusted(certificates, authType);
            }
        } else {
            Logger.debug((String)"no system trustmanager defined, checking server certificate via jameica trustmanager");
            this.checkTrusted(certificates, authType);
        }
    }

    private void checkTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("no certificates given to check, strange!");
        }
        if (Logger.isLogging((Level)Level.DEBUG)) {
            Logger.debug((String)"checking cert chain");
            for (int i = 0; i < chain.length; ++i) {
                Logger.debug((String)("  " + this.toString(chain[i])));
            }
        }
        SSLFactory factory = Application.getSSLFactory();
        try {
            X509Certificate cert;
            block14: {
                CertPath certPath = factory.getCertificateFactory().generateCertPath(Arrays.asList(chain));
                cert = (X509Certificate)certPath.getCertificates().get(0);
                boolean verified = false;
                try {
                    PKIXParameters params = new PKIXParameters(factory.getKeyStore());
                    params.setRevocationEnabled(false);
                    this.validator.validate(certPath, params);
                    Logger.debug((String)("certificate chain trusted: " + this.toString(cert)));
                    verified = true;
                }
                catch (GeneralSecurityException e) {
                    X509Certificate[] trusted;
                    for (X509Certificate c : trusted = this.getAcceptedIssuers()) {
                        if (!cert.equals(c)) continue;
                        verified = true;
                        Logger.debug((String)("peer certificate trusted: " + this.toString(c)));
                        break;
                    }
                }
                if (verified) {
                    DateFormat df = DateFormat.getDateInstance(2, Application.getConfig().getLocale());
                    String validFrom = df.format(cert.getNotBefore());
                    String validTo = df.format(cert.getNotAfter());
                    try {
                        cert.checkValidity();
                        Logger.debug((String)("validity: " + validFrom + " - " + validTo));
                        return;
                    }
                    catch (CertificateExpiredException exp) {
                        Logger.warn((String)("certificate expired: " + validFrom + " - " + validTo));
                        if (Application.getCallback().askUser(Application.getI18n().tr("Zertifikat abgelaufen. Trotzdem vertrauen?\nG\u00fcltigkeit: {0} - {1}", new String[]{validFrom, validTo}))) {
                            return;
                        }
                    }
                    catch (CertificateNotYetValidException not) {
                        Logger.warn((String)("certificate not yet valid: " + validFrom + " - " + validTo));
                        if (!Application.getCallback().askUser(Application.getI18n().tr("Zertifikat noch nicht g\u00fcltig. Trotzdem vertrauen?\nG\u00fcltigkeit: {0} - {1}", new String[]{validFrom, validTo}))) break block14;
                        return;
                    }
                }
            }
            Logger.warn((String)("import certificate: " + this.toString(cert)));
            factory.addTrustedCertificate(cert);
        }
        catch (OperationCanceledException oe) {
            Logger.warn((String)"operation cancelled");
            throw oe;
        }
        catch (Exception e) {
            Logger.error((String)"error while checking trust", (Throwable)e);
            throw new CertificateException(Application.getI18n().tr("Fehler beim Pr\u00fcfen des Zertifikats"));
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        try {
            return Application.getSSLFactory().getTrustedCertificates();
        }
        catch (Exception e) {
            Logger.error((String)"unable to load trusted certificates, fallback to system trustmanager", (Throwable)e);
            if (this.parentTrustManager != null) {
                return this.parentTrustManager.getAcceptedIssuers();
            }
            return new X509Certificate[0];
        }
    }

    private String toString(X509Certificate cert) {
        StringBuffer sb = new StringBuffer();
        sb.append("[subject: ");
        sb.append(cert.getSubjectDN().getName());
        sb.append("][valid from: ");
        sb.append(cert.getNotBefore().toString());
        sb.append(" to: ");
        sb.append(cert.getNotAfter().toString());
        sb.append("][serial: ");
        sb.append("0x" + cert.getSerialNumber().toString(16).toUpperCase());
        sb.append("]");
        return sb.toString();
    }
}

